package spikingneuron.userinterface;

import java.awt.Font;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import javax.swing.BoxLayout;
import java.awt.GridBagLayout;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.Tools;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.generators.PulsesGenerator;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 mai 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Interface utilisateur du gnrateur d'impulsions.
* </TT></STRONG><FONT SIZE=3>
* <P>
*/
public class PulsesGeneratorGI extends SignalGeneratorGI {
    DoubleGI offsetCtrl;
    DoubleGI amplitudeCtrl;
    LongGI nbPulsesCtrl;
    LongGI pulseWidthCtrl;


    // Constructeurs ...........
    public PulsesGeneratorGI() {
	super();
	description = new JLabel(Tools.loadImageIcon(getClass(),
						     "/images/pg_descr.gif",""));
	offsetCtrl	 = new DoubleGI(0.0, 10, "Io  [uA]",
					DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	amplitudeCtrl  = new DoubleGI(01.0, 10, "A   [uA]",
				      DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	nbPulsesCtrl   = new LongGI(10, 10,	 "Nb. pulsation",
				    LongGI.LABEL_AT_LEFT,JLabel.LEFT);
	pulseWidthCtrl = new LongGI(0, 10,	  "(largeur [tic])",
				    LongGI.LABEL_AT_LEFT,JLabel.LEFT);
	nbPulsesCtrl.setValidityDomaine(0,Long.MAX_VALUE);
	pulseWidthCtrl.setValidityDomaine(1,Long.MAX_VALUE);
	pulseWidthCtrl.onBack();
	makeInterface();
	makeToolTip();
    }

    public PulsesGeneratorGI(PulsesGenerator generator) {
	this();
	synchronizeSignifiant((Object)generator);
	makeInterface();
	makeToolTip();
    }

    // Divers ...................
    protected void makeToolTip() {
	offsetCtrl.setToolTipText("Courant d'offset (composante continue).");
	amplitudeCtrl.setToolTipText("Courant d'impulsion.");
	nbPulsesCtrl.setToolTipText("Nb d'impulsions a generer.");
	pulseWidthCtrl.setToolTipText("Largeur des impulsions (en tic).");
    }

    protected void makeInterface() {
	//		setBackground(Color.lightGray);
	PrimitiveTypeGroup controlGrp = new PrimitiveTypeGroup();
	controlGrp.add(offsetCtrl);
	controlGrp.add(amplitudeCtrl);
	controlGrp.add(nbPulsesCtrl);
	controlGrp.add(pulseWidthCtrl);
	setLayout(new GridBagLayout());
	Constraints gbConstraints = new Constraints();
	add(description,
	    gbConstraints.setAndGet(0,0,
				    Constraints.REMAINDER,1,
				    Constraints.NONE,
				    0,0,
				    10,10,0,0,
				    Constraints.CENTER,
				    1.0, 0.0));
	add(controlGrp,
	    gbConstraints.setAndGet(0,1,
				    Constraints.REMAINDER,1,
				    Constraints.BOTH,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    1.0, 1.0));
    }						

    // GraphicalInterface  Implementation complement ..............

    public void synchronizeSignifie(Object signifie) {
	PulsesGenerator generator = (PulsesGenerator)signifie;
	generator.setOffset(offsetCtrl.getValue()*1E-6);
	generator.setPulseAmplitude(amplitudeCtrl.getValue()*1E-6);
	generator.setNbPulses((int)nbPulsesCtrl.getValue());
	generator.setPulseWidth((int)pulseWidthCtrl.getValue());
    }

    public void synchronizeSignifiant(Object signifie) {
	PulsesGenerator generator = (PulsesGenerator)signifie;
	offsetCtrl.setValue(generator.getOffset()*1E6);
	amplitudeCtrl.setValue(generator.getPulseAmplitude()*1E6);
	nbPulsesCtrl.setValue(generator.getNbPulses());
	pulseWidthCtrl.setValue(generator.getPulseWidth());
    }
    /**
     */
    public void setFontLabels(Font textFont) {
	offsetCtrl.setFontLabels(textFont);
	amplitudeCtrl.setFontLabels(textFont);
	nbPulsesCtrl.setFontLabels(textFont);
	pulseWidthCtrl.setFontLabels(textFont);
    }
		
    /**
     */
    public Font getFontLabels() {
	return offsetCtrl.getFontLabels();
    }

    // SignalGenerator complements ...........................
    protected JLabel getSymbolicIcon(boolean selectedIcon) {
	return (selectedIcon ?
		new JLabel(Tools.loadImageIcon(getClass(),
					       "/images/pg_symbolic_S.gif",
					       "Symbolic Selected Icon representation"))
		    :
		new JLabel(Tools.loadImageIcon(getClass(),
					       "/images/pg_symbolic_U.gif",
					       "Symbolic Unselected Icon representation")));
    }
}
