package spikingneuron.userinterface;

import java.awt.Font;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import javax.swing.BoxLayout;
import java.awt.GridBagLayout;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.Tools;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.generators.RandomPulsesGenerator;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 mai 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Interface utilisateur du gnrateur d'impulsions d'occurence non dterministe.
* </TT></STRONG><FONT SIZE=3>
* <P>
*/
public class RandomPulsesGeneratorGI extends SignalGeneratorGI {
    DoubleGI offsetCtrl;
    DoubleGI amplitudeCtrl;
    DoubleGI lambdaCtrl;
    LongGI pulseWidthCtrl;
    LongGI seedCtrl;


    // Constructeurs ...........
    public RandomPulsesGeneratorGI() {
	super();
	description = new JLabel(Tools.loadImageIcon(getClass(),
						     "/images/rp_descr.gif",""));
	offsetCtrl	   = new DoubleGI(00.0, 10, "Io  [uA]",
					  DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	amplitudeCtrl  = new DoubleGI(01.0, 10, "A   [uA]",
				      DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	lambdaCtrl	   = new DoubleGI(10, 10,   "lambda",
					  DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	pulseWidthCtrl = new LongGI(0, 10,	  "(Largeur [tic])",
				    LongGI.LABEL_AT_LEFT,JLabel.LEFT);
	seedCtrl	   = new LongGI(0, 10,	  "Nb. Aleatoire",
					LongGI.LABEL_AT_LEFT,JLabel.LEFT);
	pulseWidthCtrl.setValidityDomaine(1,Long.MAX_VALUE);
	lambdaCtrl.setValidityDomaine(0.,Double.MAX_VALUE);
	pulseWidthCtrl.onBack();
	seedCtrl.onBack();
	makeInterface();
	makeToolTip();
    }

    public RandomPulsesGeneratorGI(RandomPulsesGenerator generator) {
	this();
	synchronizeSignifiant((Object)generator);
	makeInterface();
	makeToolTip();
    }

    // Divers ...................
    protected void makeToolTip() {
	offsetCtrl.setToolTipText("Courant d'offset (composante continue).");
	amplitudeCtrl.setToolTipText("Courant d'impulsion.");
	lambdaCtrl.setToolTipText("Parametre de la distr. exponentielle.");
	pulseWidthCtrl.setToolTipText("Largeur des impulsions (en tic).");
	seedCtrl.setToolTipText("Graine du generateur aleatoire.");
    }

    protected void makeInterface() {
	//		setBackground(Color.lightGray);
	PrimitiveTypeGroup controlGrp = new PrimitiveTypeGroup();
	controlGrp.add(offsetCtrl);
	controlGrp.add(amplitudeCtrl);
	controlGrp.add(lambdaCtrl);
	controlGrp.add(pulseWidthCtrl);
	controlGrp.add(seedCtrl);
	setLayout(new GridBagLayout());
	Constraints gbConstraints = new Constraints();
	add(description,
	    gbConstraints.setAndGet(0,0,
				    Constraints.REMAINDER,1,
				    Constraints.NONE,
				    0,0,
				    10,10,0,0,
				    Constraints.CENTER,
				    1.0, 0.0));
	add(controlGrp,
	    gbConstraints.setAndGet(0,1,
				    Constraints.REMAINDER,1,
				    Constraints.BOTH,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    1.0, 1.0));
    }						

    // GraphicalInterface  Implementation complement ..............

    public void synchronizeSignifie(Object signifie) {
	RandomPulsesGenerator generator = (RandomPulsesGenerator)signifie;
	generator.setOffset(offsetCtrl.getValue()*1E-6);
	generator.setPulseAmplitude(amplitudeCtrl.getValue()*1E-6);
	generator.setLambda(lambdaCtrl.getValue());
	generator.setPulseWidth((int)pulseWidthCtrl.getValue());
	generator.setSeed(seedCtrl.getValue());
    }

    public void synchronizeSignifiant(Object signifie) {
	RandomPulsesGenerator generator = (RandomPulsesGenerator)signifie;
	offsetCtrl.setValue(generator.getOffset()*1E6);
	amplitudeCtrl.setValue(generator.getPulseAmplitude()*1E6);
	lambdaCtrl.setValue(generator.getLambda());
	pulseWidthCtrl.setValue(generator.getPulseWidth());
	seedCtrl.setValue(generator.getSeed());
    }

    /**
     */
    public void setFontLabels(Font textFont) {
	offsetCtrl.setFontLabels(textFont);
	amplitudeCtrl.setFontLabels(textFont);
	lambdaCtrl.setFontLabels(textFont);
	pulseWidthCtrl.setFontLabels(textFont);
	seedCtrl.setFontLabels(textFont);
    }
		
    /**
     */
    public Font getFontLabels() {
	return offsetCtrl.getFontLabels();
    }

    // SignalGenerator complements ...........................
    protected JLabel getSymbolicIcon(boolean selectedIcon) {
	return (selectedIcon ?
		new JLabel(Tools.loadImageIcon(getClass(),
					       "/images/rp_symbolic_S.gif",
					       "Symbolic Selected Icon representation"))
		    :
		new JLabel(Tools.loadImageIcon(getClass(),
					       "/images/rp_symbolic_U.gif",
					       "Symbolic Unselected Icon representation")));
    }
}
