package spikingneuron.userinterface;

import java.awt.Font;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.BoxLayout;
import java.awt.GridBagLayout;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.Tools;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.neurons.SRMLongMemory;

/**
*<FONT SIZE=2>
* @version 1.1, Lausanne le 3 septembre 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Interface utilisateur du modle de neurones <I>SpikeResponse Long Memory</I>.
* </TT></STRONG><FONT SIZE=3>
* <P>
*/
public class SRMLongMemoryGI extends NeuronBaseModelGI {

    DoubleGI eta0Ctrl;
    DoubleGI tauEtaCtrl;

    // Constructeurs ...........
    public SRMLongMemoryGI() {
	super();
	description 	  	= new JLabel(Tools.loadImageIcon(getClass(), "/images/srl_descr.gif",""));
	mThresholdCtrl		= new DoubleGI(0.0, 05, "Thrsh [mV]", DoubleGI.LABEL_AT_LEFT, JLabel.LEFT);
	gThresholdCtrl		= new DoubleGI(0.0, 05, "gap ", DoubleGI.LABEL_AT_LEFT, JLabel.LEFT);
	mRefractoryTimeCtrl	= new DoubleGI(0.0, 05, "Refr. [ms]", DoubleGI.LABEL_AT_LEFT, JLabel.LEFT);
	gRefractoryTimeCtrl	= new DoubleGI(0.0, 05, "gap ", DoubleGI.LABEL_AT_LEFT, JLabel.LEFT);
	resistanceCtrl		= new DoubleGI(0.0, 10, "R   [MOhm]", DoubleGI.LABEL_AT_LEFT, JLabel.LEFT);
	tauSynapticCtrl		= new DoubleGI(0.0, 10, "Tau S [ms]", DoubleGI.LABEL_AT_LEFT, JLabel.LEFT);
	eta0Ctrl			= new DoubleGI(0.0, 10, "Eta 0 [mV]", DoubleGI.LABEL_AT_LEFT, JLabel.LEFT);
	tauEtaCtrl			= new DoubleGI(0.0, 10, "Tau Eta[ms]", DoubleGI.LABEL_AT_LEFT, JLabel.LEFT);
	noiseCtrl			= new DoubleGI(0.0, 05, "Courant du bruit [uA]", DoubleGI.LABEL_AT_LEFT, JLabel.LEFT);

	gThresholdCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
	mRefractoryTimeCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
	gRefractoryTimeCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
	resistanceCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
	tauSynapticCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
	noiseCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
	tauEtaCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);

	makeInterface();
	makeToolTip();
    }

    public SRMLongMemoryGI(SRMLongMemory neuron) {
	this();
	this.synchronizeSignifiant((Object)neuron);
    }

    public SRMLongMemoryGI(double meanThreshold,		double gapThreshold,
			   double meanRefractoryTime, 	double gapRefractoryTime,
			   double resistance, 			double tauSynaptic,
			   double eta0, 				double tauEta,
			   double noiseVariance) {
	this();
	mThresholdCtrl.setValue(meanThreshold*1e3);
	gThresholdCtrl.setValue(gapThreshold*1e3);
	mRefractoryTimeCtrl.setValue(meanRefractoryTime*1e3);
	gRefractoryTimeCtrl.setValue(gapRefractoryTime*1e3);
	resistanceCtrl.setValue(resistance*1e-6);
	noiseCtrl.setValue(noiseVariance*1e6);
	tauSynapticCtrl.setValue(tauSynaptic*1e3);
	eta0Ctrl.setValue(eta0*1e3);
	tauEtaCtrl.setValue(tauEta*1e3);
    }

    // Divers ...................
    protected void makeToolTip() {
	super.makeToolTip();
	eta0Ctrl.setToolTipText("Valeur initiale de la composante inhibitrice.");
	tauEtaCtrl.setToolTipText("Constante de temps de la comp. inhibitrice.");
    }

    protected void makeInterface() {
	setLayout(new GridBagLayout());
	Constraints gbConstraints = new Constraints();
	add(description,
	    gbConstraints.setAndGet(0,0,
				    Constraints.REMAINDER,1,
				    Constraints.NONE,
				    0,0,
				    5,5,0,0,
				    Constraints.CENTER,
				    1.0, 0.0));

	// Threshold .........................................................

	add(mThresholdCtrl.label,
	    gbConstraints.setAndGet(0,1,
				    1,1,
				    Constraints.NONE,
				    0,0,
				    0,0,0,0,
				    Constraints.WEST,
				    0.0, 0.1));
	add(mThresholdCtrl.signifiant,
	    gbConstraints.setAndGet(1,1,
				    1,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    0.5, 0.1));
	add(gThresholdCtrl.label,
	    gbConstraints.setAndGet(2,1,
				    1,1,
				    Constraints.NONE,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    0.0, 0.1));
	add(gThresholdCtrl.signifiant,
	    gbConstraints.setAndGet(3,1,
				    1,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,0,0,
				    Constraints.EAST,
				    0.5, 0.1));

	// Refractory Time ........................................................

	add(mRefractoryTimeCtrl.label,
	    gbConstraints.setAndGet(0,2,
				    1,1,
				    Constraints.NONE,
				    0,0,
				    0,0,0,0,
				    Constraints.WEST,
				    0.0, 0.1));
	add(mRefractoryTimeCtrl.signifiant,
	    gbConstraints.setAndGet(1,2,
				    1,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    0.5, 0.1));
	add(gRefractoryTimeCtrl.label,
	    gbConstraints.setAndGet(2,2,
				    1,1,
				    Constraints.NONE,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    0.0, 0.1));
	add(gRefractoryTimeCtrl.signifiant,
	    gbConstraints.setAndGet(3,2,
				    1,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,0,0,
				    Constraints.EAST,
				    0.5, 0.1));

	// Resistance ........................................................

	add(resistanceCtrl.label,
	    gbConstraints.setAndGet(0,3,
				    1,1,
				    Constraints.NONE,
				    0,0,
				    0,0,0,0,
				    Constraints.WEST,
				    0.0, 0.1));
	add(resistanceCtrl.signifiant,
	    gbConstraints.setAndGet(1,3,
				    Constraints.REMAINDER,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    1.0, 0.1));

	// Tau Membrane .........................................................

	add(tauSynapticCtrl.label,
	    gbConstraints.setAndGet(0,4,
				    1,1,
				    Constraints.NONE,
				    0,0,
				    0,0,0,0,
				    Constraints.WEST,
				    0.0, 0.1));
	add(tauSynapticCtrl.signifiant,
	    gbConstraints.setAndGet(1,4,
				    Constraints.REMAINDER,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    1.0, 0.1));

	// Eta 0 ........................................................

	add(eta0Ctrl.label,
	    gbConstraints.setAndGet(0,5,
				    1,1,
				    Constraints.NONE,
				    0,0,
				    0,0,0,0,
				    Constraints.WEST,
				    0.0, 0.1));
	add(eta0Ctrl.signifiant,
	    gbConstraints.setAndGet(1,5,
				    Constraints.REMAINDER,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    1.0, 0.1));

	// Tau Eta ........................................................

	add(tauEtaCtrl.label,
	    gbConstraints.setAndGet(0,6,
				    1,1,
				    Constraints.NONE,
				    0,0,
				    0,0,0,0,
				    Constraints.WEST,
				    0.0, 0.1));
	add(tauEtaCtrl.signifiant,
	    gbConstraints.setAndGet(1,6,
				    Constraints.REMAINDER,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    1.0, 0.1));

	// Variance du courant de bruit........................................................

	add(noiseCtrl.label,
	    gbConstraints.setAndGet(0,7,
				    2,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,0,0,
				    Constraints.WEST,
				    0.5, 0.1));
	add(noiseCtrl.signifiant,
	    gbConstraints.setAndGet(2,7,
				    Constraints.REMAINDER,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    0.5, 0.1));
    }						

    // GraphicalInterface implementation complement ...............
    public void synchronizeSignifie(Object signifie) {
	SRMLongMemory neuron = (SRMLongMemory)signifie;
	super.synchronizeSignifie(neuron);
	neuron.setEta0(eta0Ctrl.getValue()*1E-3);
	neuron.setTauEta(tauEtaCtrl.getValue()*1E-3);
    }
	
    public void synchronizeSignifiant(Object signifie) {
	SRMLongMemory neuron = (SRMLongMemory)signifie;
	super.synchronizeSignifiant(neuron);
	eta0Ctrl.setValue(neuron.getEta0()*1E3);
	tauEtaCtrl.setValue(neuron.getTauEta()*1E3);
    }

    public void setFontLabels(Font textFont) {
	super.setFontLabels(textFont);
	eta0Ctrl.setFontLabels(textFont);
	tauEtaCtrl.setFontLabels(textFont);
    }
		
    // NeuronBaseModelGI implements ..............................
    protected JLabel getSymbolicIcon(boolean selectedIcon) {
	return (selectedIcon ?
		new JLabel(Tools.loadImageIcon(getClass(), "/images/srl_symbolic_S.gif", "Symbolic Selected Icon representation"))
		    :
		new JLabel(Tools.loadImageIcon(getClass(), "/images/srl_symbolic_U.gif", "Symbolic Unselected Icon representation")));
    }
}
