package spikingneuron.userinterface;

import java.awt.Font;
import com.objectspace.jgl.Pair;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JComponent;
import spikingneuron.generators.SignalGenerator;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 mai 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Classe de base (<B>abstraite</B>) pour les interfaces utilisateurs des gnrateurs de courant.
* </TT></STRONG><FONT SIZE=3>
* <P>
* Signifiant & signifi totalement indpendant (Aucune rfrence n'est stocke...).
* @see spikingneuron.userinterface.GraphicalInterface
*/
public abstract class SignalGeneratorGI extends JPanel implements GraphicalInterface {

    protected Pair symbolic; // reprsentation symbolique
    protected JComponent description;
	

    // Constructeurs .................
    protected SignalGeneratorGI() {
	super();
	description = null;
	symbolic = new Pair(getSymbolicIcon(false),
			    getSymbolicIcon(true));
    }
    // GraphicalInterface implementation ................
    public JComponent getInterface() {
	return this;
    }
    public Object getSymbolic() {
	// La mthode doit retourner un instance, mais pas en crer,
	// pour que le stockage dans CardLayout avec le hashCode comme
	// identifiant soit possible...
	return symbolic;		
    }

    public void synchronizeSignifie() throws UnsupportedSynchronization {
	throw new UnsupportedSynchronization();
    }
    public void synchronizeSignifiant() throws UnsupportedSynchronization {
	throw new UnsupportedSynchronization();
    }
    // Redfinition des mthodes, sans la clause throws...
    public abstract void synchronizeSignifie(Object signifie);
    public abstract void synchronizeSignifiant(Object signifie);

    // Divers ..................	
    // Cette methode doit retourner un JLabel correctement construit,
    // avant que l'objet ne soit entirement construit.
    // Invocation de cette mthode avant invocation du constructeur...
    protected abstract JLabel getSymbolicIcon(boolean selectedIcon);

}

/*----------------------------------------------------
  Mthodes abstraites:
  --------------------
  public abstract void synchronizeSignifie(Object)   : synchro d'une instance
  public abstract void synchronizeSignifiant(Object) : synchro en fct d'une instance
  protected abstract JLabel getSymbolicIcon(boolean) : JLabel utilis comme symbole
  public abstract void setFontLabels(Font textFont)  : utilise textFont pour tous les labels
  public abstract Font getFontLabels()               : retourne la font des labels
  ------------------------------------------------------- */
