package spikingneuron.userinterface;

import java.awt.Font;
import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import spikingneuron.tools.Tools;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.generators.SquareGenerator;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 mai 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Interface utilisateur du gnrateur de signal carr.
* </TT></STRONG><FONT SIZE=3>
* <P>
*/
public class SquareGeneratorGI extends SignalGeneratorGI {
    DoubleGI currentsCtrl[];
    DoubleGI timingCtrl[];

    // Constructeurs ...........
    public SquareGeneratorGI() {
	super();
	description = new JLabel(Tools.loadImageIcon(getClass(),
						     "/images/sg_descr.gif",""));
	timingCtrl = new DoubleGI[8];
	currentsCtrl = new DoubleGI[3];
	currentsCtrl[0] = new DoubleGI(0.0,5, "Io",
				       DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	currentsCtrl[1] = new DoubleGI(0.0,5, "Ih",
				       DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	currentsCtrl[2] = new DoubleGI(0.0,5, "Il",
				       DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	for (int i=0; i<8; i++) {
	    timingCtrl[i] = new DoubleGI(0.0,5, "t"+(i+1),
					 DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	    timingCtrl[i].setValidityDomaine(0.0, Double.MAX_VALUE);
	}
	makeInterface();
	makeToolTip();
    }

    public SquareGeneratorGI(SquareGenerator generator) {
	this();
	synchronizeSignifiant((Object)generator);
	makeInterface();
	makeToolTip();
    }

    // Divers ...................
    protected void makeToolTip() {
	currentsCtrl[0].setToolTipText("Courant d'offset (composante continue) [uA].");
	currentsCtrl[1].setToolTipText("Courant maximum [uA]");
	currentsCtrl[2].setToolTipText("Courant minimum [uA]");
	timingCtrl[0].setToolTipText("Duree de la 1ere phase, en milisecondes.");
	timingCtrl[1].setToolTipText("Duree de la 2nd phase, en milisecondes.");
	timingCtrl[2].setToolTipText("Duree de la 3nd phase, en milisecondes.");
	timingCtrl[3].setToolTipText("Duree de la 4nd phase, en milisecondes.");
	timingCtrl[4].setToolTipText("Duree de la 5nd phase, en milisecondes.");
	timingCtrl[5].setToolTipText("Duree de la 6nd phase, en milisecondes.");
	timingCtrl[6].setToolTipText("Duree de la 7nd phase, en milisecondes.");
	timingCtrl[7].setToolTipText("Duree de la 8nd phase, en milisecondes.");
    }

    protected void makeInterface() {
	//		setBackground(Color.lightGray);
	setLayout(new GridBagLayout());
	Constraints gbConstraints = new Constraints();
	add(description,
	    gbConstraints.setAndGet(0,0,
				    Constraints.REMAINDER,1,
				    Constraints.NONE,
				    0,0,
				    10,10,0,0,
				    Constraints.CENTER,
				    1.0, 0.0));
	add(currentsCtrl[0].label,
	    gbConstraints.setAndGet(2,1,
				    1,1,
				    Constraints.NONE,
				    0,0,
				    0,0,3,1,
				    Constraints.EAST,
				    0.0, 0.1));
	add(currentsCtrl[0].signifiant,
	    gbConstraints.setAndGet(3,1,
				    1,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,1,0,
				    Constraints.NORTH,
				    0.5, 0.1));
	add(currentsCtrl[1].label,
	    gbConstraints.setAndGet(0,2,
				    1,1,
				    Constraints.NONE,
				    0,0,
				    0,0,0,1,
				    Constraints.WEST,
				    0.0, 0.1));
	add(currentsCtrl[1].signifiant,
	    gbConstraints.setAndGet(1,2,
				    1,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,1,1,
				    Constraints.WEST,
				    0.5, 0.1));

	add(currentsCtrl[2].label,
	    gbConstraints.setAndGet(2,2,
				    1,1,
				    Constraints.NONE,
				    0,0,
				    0,0,3,1,
				    Constraints.EAST,
				    0.0, 0.1));
	add(currentsCtrl[2].signifiant,
	    gbConstraints.setAndGet(3,2,
				    1,1,
				    Constraints.HORIZONTAL,
				    0,0,
				    0,0,1,0,
				    Constraints.NORTH,
				    0.5, 0.1));

	for (int i = 0; i<timingCtrl.length; ) {
	    add(timingCtrl[i].label,
		gbConstraints.setAndGet(0,3+i,
					1,1,
					Constraints.NONE,
					0,0,
					0,0,0,1,
					Constraints.WEST,
					0.0, 0.1));
	    add(timingCtrl[i++].signifiant,
		gbConstraints.setAndGet(1,2+i, // increment
					1,1,
					Constraints.HORIZONTAL,
					0,0,
					0,0,1,1,
					Constraints.WEST,
					0.5, 0.1));
	    add(timingCtrl[i].label,
		gbConstraints.setAndGet(2,2+i,
					1,1,
					Constraints.NONE,
					0,0,
					0,0,1,1,
					Constraints.EAST,
					0.0, 0.1));
	    add(timingCtrl[i++].signifiant,
		gbConstraints.setAndGet(3,1+i,
					1,1,
					Constraints.HORIZONTAL,
					0,0,
					0,0,1,0,
					Constraints.NORTH,
					0.5, 0.1));
	}
    }						

    // GraphicalInterface  Implementation complement ..............

    public void synchronizeSignifie(Object signifie) {
	SquareGenerator generator = (SquareGenerator)signifie;
	generator.setIOffset(currentsCtrl[0].getValue()*1E-6);
	generator.setIHigh(currentsCtrl[1].getValue()*1E-6);
	generator.setILow(currentsCtrl[2].getValue()*1E-6);
	for (int i=0; i<8; i++)
	    generator.setTiming(i, timingCtrl[i].getValue()*1E-3);
    }

    public void synchronizeSignifiant(Object signifie) {
	SquareGenerator generator = (SquareGenerator)signifie;
	currentsCtrl[0].setValue(generator.getIOffset()*1E6);
	currentsCtrl[1].setValue(generator.getIHigh()*1E6);
	currentsCtrl[2].setValue(generator.getILow()*1E6);
	for (int i = 0; i<8; i++)
	    timingCtrl[i].setValue(generator.getTiming(i)*1E3);
    }

    /**
     */
    public void setFontLabels(Font textFont) {
	for (int i = currentsCtrl.length; i>0;)
	    currentsCtrl[--i].setFontLabels(textFont);
	for (int i = timingCtrl.length; i>0;)
	    timingCtrl[--i].setFontLabels(textFont);
    }
		
    /**
     */
    public Font getFontLabels() {
	return currentsCtrl[0].getFontLabels();
    }

    // SignalGenerator complements ...........................
    protected JLabel getSymbolicIcon(boolean selectedIcon) {
	return (selectedIcon ?
		new JLabel(Tools.loadImageIcon(getClass(),
					       "/images/sg_symbolic_S.gif",
					       "Symbolic Selected Icon representation"))
		    :
		new JLabel(Tools.loadImageIcon(getClass(),
					       "/images/sg_symbolic_U.gif",
					       "Symbolic Unselected Icon representation")));
    }
}
