package spikingneuron.userinterface;

import java.awt.Font;
import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import spikingneuron.tools.Tools;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.generators.StepGenerator;

/**
*<FONT SIZE=2>
* @version 1.0, Lausanne le 18 mai 1998
* @author Florian Seydoux (EPFL-Lami-Mantra, projet <I>Spiking Neurons</I>.) <HR>
* <P><FONT SIZE=4><TT><STRONG>
* Interface utilisateur du gnrateur <I>'Step'</I>.
* </TT></STRONG><FONT SIZE=3>
* <P>
*/
public class StepGeneratorGI extends SignalGeneratorGI {
    DoubleGI i0Ctrl;
    DoubleGI i1Ctrl;
    DoubleGI ratioCtrl;

    // Constructeurs ...........
    public StepGeneratorGI() {
	super();
	description = 	new JLabel(Tools.loadImageIcon(getClass(),
						       "/images/stepg_descr.gif",""));
	i0Ctrl		=	new DoubleGI(00.0, 10, "I initial [uA]",
					     DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	i1Ctrl		=	new DoubleGI(00.0, 10, "I final   [uA]",
					     DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	ratioCtrl	=	new DoubleGI(00.0, 10, "Temps du flanc [%]",
					     DoubleGI.LABEL_AT_LEFT,JLabel.LEFT);
	ratioCtrl.setValidityDomaine(0.0,100.0);
	makeInterface();
	makeToolTip();
    }

    public StepGeneratorGI(StepGenerator generator) {
	this();
	synchronizeSignifiant((Object)generator);
	makeInterface();
	makeToolTip();
    }

    // Divers ...................
    protected void makeToolTip() {
	i0Ctrl.setToolTipText("Courant de la premiere partie du signal.");
	i1Ctrl.setToolTipText("Courant de la seconde (derniere) partie du signal");
	ratioCtrl.setToolTipText("Moment d'occurence du flanc, en % "+
				 "par rapport au temps total simule.");
    }

    protected void makeInterface() {
	//		setBackground(Color.lightGray);
	PrimitiveTypeGroup controlGrp = new PrimitiveTypeGroup();
	controlGrp.add(i0Ctrl);
	controlGrp.add(i1Ctrl);
	controlGrp.add(ratioCtrl);
	setLayout(new GridBagLayout());
	Constraints gbConstraints = new Constraints();
	add(description,
	    gbConstraints.setAndGet(0,0,
				    Constraints.REMAINDER,1,
				    Constraints.NONE,
				    0,0,
				    10,10,0,0,
				    Constraints.CENTER,
				    1.0, 0.0));
	add(controlGrp,
	    gbConstraints.setAndGet(0,1,
				    Constraints.REMAINDER,1,
				    Constraints.BOTH,
				    0,0,
				    0,0,0,0,
				    Constraints.CENTER,
				    1.0, 1.0));
    }						

    // GraphicalInterface  Implementation complement ..............

    public void synchronizeSignifie(Object signifie) {
	StepGenerator generator = (StepGenerator)signifie;
	generator.setInitialCurrent(i0Ctrl.getValue()*1E-6);
	generator.setFinalCurrent(i1Ctrl.getValue()*1E-6);
	generator.setRaiseTimeRatio(ratioCtrl.getValue()*1E-2);
    }

    public void synchronizeSignifiant(Object signifie) {
	StepGenerator generator = (StepGenerator)signifie;
	i0Ctrl.setValue(generator.getInitialCurrent()*1E6);
	i1Ctrl.setValue(generator.getFinalCurrent()*1E6);
	ratioCtrl.setValue(generator.getRaiseTimeRatio()*1E2);
    }
    /**
     */
    public void setFontLabels(Font textFont) {
	i0Ctrl.setFontLabels(textFont);
	i1Ctrl.setFontLabels(textFont);
	ratioCtrl.setFontLabels(textFont);
    }
		
    /**
     */
    public Font getFontLabels() {
	return i0Ctrl.getFontLabels();
    }

    // SignalGenerator complements ...........................
    protected JLabel getSymbolicIcon(boolean selectedIcon) {
	return (selectedIcon ?
		new JLabel(Tools.loadImageIcon(getClass(),
					       "/images/stepg_symbolic_S.gif",
					       "Symbolic Selected Icon representation"))
		    :
		new JLabel(Tools.loadImageIcon(getClass(),
					       "/images/stepg_symbolic_U.gif",
					       "Symbolic Unselected Icon representation")));
    }
}
